package view;

import java.awt.GridLayout;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import control.EnterListener;

import model.Catalogo;
import model.ProxyPezzo;

public class PezzoPanel extends JPanel {

	private static final long serialVersionUID = 1L;
	
	private Catalogo catalogo;
	
	private JLabel pezzoLabel = new JLabel("CodiceID");
	private JTextField pezzoText = new JTextField(20);
	private JLabel dateLabel = new JLabel("Anno");
	private JTextField dateText = new JTextField(5);
	private JLabel descrLabel = new JLabel("Descrizione");
	private JTextField descrText = new JTextField(10);
	private JLabel salaLabel = new JLabel("Sala");

	private String[] sale = new String[] { "il Salone Medioevale",
			"il Salone Rinascimentale", "la Sala dell'Inquisizione",
			"la Sala delle Scienze Moderne",
			"la Sala delle Tecnologie moderne" };
	
	private JComboBox<String> box = new JComboBox<String>(sale);

	public PezzoPanel(Catalogo catalogo) {
		this.catalogo = catalogo;

		setBorder(BorderFactory.createEtchedBorder());
		setLayout(new GridLayout());

		JButton button = new JButton("Inserisci");

		add(pezzoLabel);
		add(pezzoText);
		add(dateLabel);
		add(dateText);
		add(descrLabel);
		add(descrText);
		add(salaLabel);
		add(this.box);
		add(button);

		EnterListener listener = new EnterListener(catalogo, pezzoText,
				dateText, descrText, box);
		button.addActionListener(listener);

	}
}
